function [Mee,Nee] = bfor_endogenous_ms_solver_matrices_ee(nderivs, Pmatss, H, G, G2)
% 
% Returns the matrices Mee and Nee for solving the second order derivative
%   with respect to epsilon, epsilon
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  Pmatss   = (ns x ns) matrix of the transition matrix at steady state
%  H        = (nx x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, H(i,j,s) is the response of x(i) 
%               to state(j) given regime s, state=[xlag;epsilon;chi]
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               non-predetermined variables, G(i,j,s) is the response of 
%               y(i) to state(j) given regime s, state=[xlag;epsilon;chi]
%  G2       = (ny x (nx+ne+1)^2 x ns) array for second-order solution for 
%               the non-predetermined variables, G2(i,j,s) is the response 
%               of y(i) to the j-element of kron(state,state) conditional 
%               on regime s
%  
%  OUTPUTS
%   Mee     = {ns x ns) cell of derivative coefficients for solving the
%               system
%   Nee     = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% -- Other Setup -- %
ny  = size(G,1);
nx  = size(H,1);
ne  = size(H,2)-nx-1;
ns  = length(Pmatss);
n   = nx + ny;
Mee = cell(ns,ns);
Nee = cell(ns,ns);

dPy = nderivs.dPy;

for s = 1:ns
    for sp = 1:ns
        dfyp          = nderivs.dfyp{sp,s};
        dfy           = nderivs.dfy{sp,s};
        dfx           = nderivs.dfx{sp,s};
        dfe           = nderivs.dfe{sp,s};
        dfypyp        = nderivs.dfypyp{sp,s};
        dfypy         = nderivs.dfypy{sp,s};
        dfypx         = nderivs.dfypx{sp,s};
        dfype         = nderivs.dfype{sp,s};
        dfyy          = nderivs.dfyy{sp,s};
        dfyx          = nderivs.dfyx{sp,s};
        dfye          = nderivs.dfye{sp,s};
        dfxx          = nderivs.dfxx{sp,s};
        dfxe          = nderivs.dfxe{sp,s};
        dfee          = nderivs.dfee{sp,s};
        
        Mee{sp,s} = Pmatss(s,sp)*[kron(eye(ne*ne),dfx+dfyp*G(:,1:nx,sp)) kron(eye(ne*ne),dfy)];
        Nee{sp,s} = zeros(n*ne*ne,1);
        for cc = 1:ne
            for bb = 1:ne
                for aa = 1:n
                    loc = (cc-1)*n*ne + (bb-1)*n + aa;
                    Nee{sp,s}(loc) = 0;          
                    for ii = 1:ny  
                        Nee{sp,s}(loc) = Nee{sp,s}(loc) ...
                            + Pmatss(s,sp)*(reshape(dfypyp(aa,ii,:),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s) + reshape(dfypy(aa,ii,:),1,[])*G(:,nx+cc,s) + reshape(dfypx(aa,ii,:),1,[])*H(:,nx+cc,s) + reshape(dfype(aa,ii,cc),1,[]))*G(ii,1:nx,sp)*H(:,nx+bb,s) ...
                            + Pmatss(s,sp)*(reshape(dfypy(aa,:,ii),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s)  + reshape(dfyy(aa,ii,:),1,[])*G(:,nx+cc,s)  + reshape(dfyx(aa,ii,:),1,[])*H(:,nx+cc,s)  + reshape(dfye(aa,ii,cc),1,[]))*G(ii,nx+bb,s);
                    end
                    for ii = 1:nx
                       Nee{sp,s}(loc) = Nee{sp,s}(loc) ...
                           + Pmatss(s,sp)*(reshape(dfypx(aa,:,ii),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s) + reshape(dfyx(aa,:,ii),1,[])*G(:,nx+cc,s) + reshape(dfxx(aa,:,ii),1,[])*H(:,nx+cc,s) + reshape(dfxe(aa,ii,cc),1,[]))*H(ii,nx+bb,s) ...
                           + Pmatss(s,sp)*(dfyp(aa,:)*G2(:,(ii-1)*(nx+ne+1)+1:(ii-1)*(nx+ne+1)+nx,sp)*H(ii,nx+bb,s)*H(:,nx+cc,s));
                    end
                    Nee{sp,s}(loc) = Nee{sp,s}(loc) ...
                        + Pmatss(s,sp)*(reshape(dfype(aa,:,bb),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s) + dfye(aa,:,bb)*G(:,nx+cc,s) + dfxe(aa,:,bb)*H(:,nx+cc,s) + dfee(aa,bb,cc)) ...
                        + shiftdim(dPy(s,sp,:),1)*G(:,nx+cc,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,nx+bb,s) + dfy(aa,:)*G(:,nx+bb,s) + dfx(aa,:)*H(:,nx+bb,s) + dfe(aa,bb)) ...
                        + shiftdim(dPy(s,sp,:),1)*G(:,nx+bb,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,nx+cc,s) + dfy(aa,:)*G(:,nx+cc,s) + dfx(aa,:)*H(:,nx+cc,s) + dfe(aa,cc));
                end
            end
        end        
    end
end